using CRM007.CRM.SDK.Core;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using System;
using System.Diagnostics;
using System.Collections.Generic;
using VRM.Integration.Servicebus.Core;
using VIMT.VirtualMeetingRoom.Messages;
using VRM.Integration.Servicebus.Logging.CRM.Util;
using VIMT.VirtualMeetingRoom.Services;
using VIMT.VirtualMeetingRoom.Services.Vyopta.UcManager;
 using Logger = VRM.Integration.Servicebus.Core.Logger;
namespace VIMT.VirtualMeetingRoom.Processors
{
	class DeleteMeetingProcessor 
	{
	/// <summary>
	/// VIMT Enterprise Component for VIMT.VirtualMeetingRoom,DeleteMeeting method, Processpr.
	/// Code Generated by IMS on: 4/12/2016 6:50:07 PM
	/// Version: 2016.04.08
	/// </summary>
	/// <param name=none></param>
	/// <returns>none</returns>
		public IMessageBase Execute(VIMTVirtualDeleteMeetingRequest request)
		{
			//var request = message as DeleteMeetingRequest;
			VIMTVirtualDeleteMeetingResponse response = null;
			var progressString = "Top of Processor";
			try
			{
				if (request == null)
				{
					Logger.Instance.Warn(string.Format("{0} recieved a null message", GetType().FullName));
				}
				else
				{
				#region do legacy webservice calls
					string method = "DeleteMeetingProcessor", webService = "DeleteMeeting";
					
					var DeleteMeetingResponse = new DeleteMeetingResponse();
					Stopwatch thisTimer = Stopwatch.StartNew();
						
					try
					{
						SoapLog.Current.Active = true;
							var DeleteMeetingRequestData = new DeleteMeetingRequest();
							if(!string.IsNullOrEmpty(request.deletemeetingrequestInfo.mcs_EncounterId)) DeleteMeetingRequestData.EncounterId = request.deletemeetingrequestInfo.mcs_EncounterId;
							if(!string.IsNullOrEmpty(request.deletemeetingrequestInfo.mcs_MiscData)) DeleteMeetingRequestData.MiscData = request.deletemeetingrequestInfo.mcs_MiscData;
						var service = ServiceFactory.GetVirtualMeetingRoomWebServiceReference();
						
						DeleteMeetingResponse = service.DeleteMeeting(DeleteMeetingRequestData);
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
					}
					catch (Exception ex)
					{
						thisTimer.Stop();
						LogHelper.LogInfo(request.OrganizationName, request.LogSoap, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, SoapLog.Current.Log, thisTimer.ElapsedMilliseconds);
						SoapLog.Current.Active = false;
						SoapLog.Current.ClearLog();
						LogHelper.LogTiming(request.OrganizationName, request.LogTiming, request.UserId, request.RelatedParentId, request.RelatedParentEntityName, request.RelatedParentFieldName, method, webService,thisTimer.ElapsedMilliseconds);
						if (response == null) response = new VIMTVirtualDeleteMeetingResponse();
						var messageTest = ex.Message.ToLower();
						if (messageTest.Contains("no records"))
						{
							return response;
						}
						if (messageTest.Contains("shareexception"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("access violation"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						if (messageTest.Contains("sensitive"))
						{
							response.ExceptionOccured = true;
							response.ExceptionMessage = messageTest;
							return response;
						}
						LogHelper.LogError(request.OrganizationName, request.UserId, "DeleteMeeting Processor", ex);
						response.ExceptionOccured = true;
						response.ExceptionMessage = messageTest;
						return response;
					}
						
					progressString = "Before Mapping";
					try
					{
						response = new VIMTVirtualDeleteMeetingResponse();
						//DeleteMeetingResponse Mapping 
						#region  DeleteMeetingResponse Mapping 
						var VIMTVirtualDeleteMeetingResponseDataInfo  = new VIMTVirtualDeleteMeetingResponseData();
						VIMTVirtualDeleteMeetingResponseDataInfo.mcs_MiscData = DeleteMeetingResponse.MiscData;
						progressString = "DeleteMeetingResponse.MiscData";
						response.VIMTVirtualDeleteMeetingResponseDataInfo = VIMTVirtualDeleteMeetingResponseDataInfo;
						progressString = "After DeleteMeetingResponse Mapping";
						
						//passing to parentDTOName 
						//No records existed beyond parent 
						#endregion
					}
					catch (Exception ex)
					{
					
					 LogHelper.LogError(request.OrganizationName, request.UserId, "deletemeeting Processor, Progess:" + progressString, ex);
					if (response == null) response = new VIMTVirtualDeleteMeetingResponse();
					response.ExceptionOccured = true;
					response.ExceptionMessage = ex.Message;
					return response;
					}
				#endregion
			}
			return response;
			}
			catch (Exception ex)
			{
				
				 LogHelper.LogError(request.OrganizationName, request.UserId, "deletemeeting Processor, Progess:" + progressString, ex);
				if (response == null) response = new VIMTVirtualDeleteMeetingResponse();
				response.ExceptionOccured = true;
				response.ExceptionMessage = ex.Message;
				return response;
			}
		}
	}
}
